
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{veraoposter}[]

% --- Class structure: declaration of options part
% ---
% This class extends the a0poster class
% Read all the documentclass options; pass them to a0poster,
% unless the file "<currentoption>.veraoposter" exists, then it is loaded
\DeclareOption*{\InputIfFileExists{\CurrentOption.veraoposter}{}{
    % 
    \PassOptionsToClass{\CurrentOption}{a0poster}}}

% --- Class structure: execution of options part
% ---
\ProcessOptions \relax
% --- Class structure: declaration of options part
% ---
\LoadClass{a0poster}

\ExecuteOptions{final}
\ProcessOptions

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PACKAGES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\RequirePackage{multicol} % This is so we can have multiple columns of text side-by-side
\columnsep=100pt % This is the amount of white space between the columns in the poster
\columnseprule=3pt % This is the thickness of the black line between the columns in the poster
\RequirePackage[portuguese]{babel}
\RequirePackage{babelbib}

\RequirePackage[svgnames]{xcolor} 
\RequirePackage{amsmath}
\RequirePackage{graphicx} % Required for including images
\RequirePackage{booktabs} % Top and bottom rules for table
\RequirePackage[font=small,labelfont=bf]{caption} % Required for specifying captions to tables and figures
\RequirePackage{amsfonts, amsmath, amsthm, amssymb} % For math fonts, symbols and environments
\RequirePackage{wrapfig} % Allows wrapping text around tables and figures
\RequirePackage{tikz}
\usetikzlibrary{calc}
\usetikzlibrary{fadings}
\RequirePackage{caption}
\RequirePackage{etoolbox}
\usepackage{eso-pic}
\usepackage[export]{adjustbox}
\usepackage{multicol}

\usepackage{fancyhdr}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% FONTS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% size 24.88pt
\renewcommand{\tiny}{\fontsize{12}{14}\selectfont}
\renewcommand{\scriptsize}{\fontsize{14.4}{18}\selectfont}
\renewcommand{\footnotesize}{\fontsize{17.28}{22}\selectfont}
\renewcommand{\small}{\fontsize{20.74}{25}\selectfont}
\renewcommand{\normalsize}{\fontsize{24.88}{30}\selectfont}
\renewcommand{\large}{\fontsize{29.86}{37}\selectfont}
\renewcommand{\Large}{\fontsize{35.83}{45}\selectfont}
\renewcommand{\LARGE}{\fontsize{43}{54}\selectfont}
\renewcommand{\huge}{\fontsize{51.6}{64}\selectfont}
\renewcommand{\Huge}{\fontsize{61.92}{77}\selectfont}
\renewcommand{\veryHuge}{\fontsize{74.3}{93}\selectfont}
\renewcommand{\VeryHuge}{\fontsize{89.16}{112}\selectfont}
\renewcommand{\VERYHuge}{\fontsize{107}{134}\selectfont}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MARGINS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% A0 dimensions 841 x 1189 mm  33.1 x 46.8 in
\special{papersize=46.8in,33.1in}
\setlength{\paperwidth}{84.1cm}
\setlength{\paperheight}{118.9cm}
\setlength{\textwidth}{84.1cm}
\setlength{\textheight}{114.9cm}
\newlength{\imagewidth}
\setlength{\imagewidth}{\paperwidth}
\newlength{\imageheight}
\setlength{\imageheight}{\paperheight}

\topskip0pt
\setlength{\headheight}{0pt}
\setlength{\headsep}{0pt}
\setlength{\topmargin}{-0pt}
\setlength{\leftmargin}{-0pt}
\setlength{\rightmargin}{-0pt}
%\setlength{\oddsidemargin}{0pt}

\usepackage[top=1cm, bottom=2cm, left=2cm, right=2cm]{geometry} % Adjusted margins

\setlength{\columnseprule}{0pt}

\setlength{\columnsep}{2cm}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% COMMANDS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Define the \printheaderfooter command
\newcommand{\printheaderfooter}{%
    \pagestyle{fancy}
    \fancyhf{} % clear all header and footer fields
    \fancyhead[C]{\includegraphics[width=0.9\paperwidth]{logo.jpeg}} % Header with the image
    \vspace*{3cm}
    \fancyfoot[C]{\colorbox[HTML]{000000}{\makebox[0.95\paperwidth][c]{\textcolor{white}{Escola de Verão 2024}}}}
    \renewcommand{\headrulewidth}{0pt} 
    %\renewcommand{\headrule}{\color[HTML]{000000}\hrule width\headwidth height\headrulewidth \vskip-\headrulewidth}
    \renewcommand{\footrulewidth}{0pt} % remove footer line
    \vspace*{12cm} % Adiciona um espaço vertical após o header
    %\textcolor[HTML]{000000}{\rule{\paperwidth}{0.4pt}}
}

